<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="{{ csrf_token() }}">
	<title>{{ get_option('brand_name', 'Casual Fitness') }}</title>

	<link rel="icon" href="{{ logo_url('favicon') }}">

	<!-- GOOGLE FONT: SOURCE SANS PRO -->
	<link rel="stylesheet"
		href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

	<!-- ICHECK BOOTSTRAP -->
	<link href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}" rel="stylesheet" type="text/css" />

	<!-- FONT AWESOME ICONS -->
	<link href="{{ asset('plugins/fontawesome-free/css/all.min.css') }}" rel="stylesheet" type="text/css" />

	<!-- THEME STYLE -->
	<link href="{{ asset('assets/css/adminlte.min.css') }}" rel="stylesheet" type="text/css" />

	<!-- TOASTR -->
	<link rel="stylesheet" href="{{ asset('plugins/toastr/toastr.min.css') }}">

	<!-- SELECT2 -->
	<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}" type="text/css" />
	
	<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}"
		type="text/css" />

	<!-- TEMPUSDOMINUS BOOTSTRAP 4 -->
	<link rel="stylesheet" href="{{ asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}"
		type="text/css" />

	<!-- ALL GENERAL STYLES USED THROUGH OUT THE APPLICATION -->
	<link href="{{ asset('assets/css/general.css') }}" rel="stylesheet" type="text/css" />

	<!-- dropzonejs -->
	<link href="{{ asset('plugins/dropzone/min/dropzone.min.css') }}" rel="stylesheet" type="text/css" />

	@yield('styles')
</head>

<body class="hold-transition sidebar-mini text-sm layout-fixed">
	<div class="wrapper">
		<!-- PRELOADER -->
		<div class="preloader flex-column justify-content-center align-items-center">
			<div class="spinner-border text-primary" role="status">
				<span class="sr-only">Loading...</span>
			</div>
		</div>
		<x-navbar />
		<x-sidebar.sidebar />
		@yield('content')
		<x-footer />
	</div>
	<!-- LOGOUT DIALOG BOX -->
	<div class="modal fade" id="modal-default">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title">{{ __('dashboard.logout_title') }}</h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<p>{{ __('dashboard.logout_message') }}</p>
				</div>
				<div class="modal-footer justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal">{{ __('dashboard.logout_dismiss')
						}}</button>
					<form method="POST" action="{{ route('logout') }}">
						@csrf
						<a onclick="event.preventDefault(); this.closest('form').submit();" class="btn btn-primary"
							data-widget="logout" href="#" role="button">{{ __('dashboard.logout') }}</a>
					</form>
				</div>
			</div>
		</div>
	</div>

	<!-- JQUERY -->
	<script src="{{ asset('plugins/jquery/jquery.min.js') }}"></script>

	<!-- BOOTSTRAP -->
	<script src="{{ asset('plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script>

	<!-- ADMINLTE -->
	<script src="{{ asset('assets/js/adminlte.js') }}"></script>

	<!-- TOASTR -->
	<script src="{{ asset('plugins/toastr/toastr.min.js') }}"></script>

	<!-- OPTIONAL SCRIPTS -->
	<script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>

	<!-- InputMask -->
	<script src="{{ asset('plugins/moment/moment.min.js') }}"></script>

	<!--  SELECT2 -->
	<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>

	<!-- DROPZONEJS -->
	<script src="{{ asset('plugins/dropzone/min/dropzone.min.js') }}"></script>

	<!-- TEMPUSDOMINUS BOOTSTRAP 4 -->
	<script src="{{ asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script>

	<!-- DISPLAY MESSAGES -->
	<script type="text/javascript">
		$(function () {
			"use strict";
			// SHOW SUCCESS MESSAGE
			@if (Session:: has('success'))
				toastr.success(' {{ session('success') }} ')
			@endif

			// SHOW ERROR MESSAGE
			@if (Session:: has('error'))
			toastr.error('{{ session('error') }}')
			@endif
			});
	</script>

	<!-- GENERAL FUNCTION'S USED THROUGHOUT THE APPLICATION -->
	<script src="{{ asset('assets/js/general.js') }}"></script>

	{{-- "global" vars, built using blade --}}
	<script>
		var imagesPath = '{{ URL::asset('images') }}';
	</script>

	<!-- ADD CUSTOM SCRIPT FOR SPECIFIC FILES -->
	@yield('js-script')
</body>

</html>